/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain;

import com.google.common.collect.Sets;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.blocks.EndBlockProperties;
import org.betterx.betterend.blocks.SulphurCrystalBlock;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.util.GlobalState;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;

public class SulphuricLakeFeature
extends DefaultFeature {
    private static final OpenSimplexNoise NOISE = new OpenSimplexNoise(15152L);

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        BlockPos blockPos = featureConfig.m_159777_();
        WorldGenLevel world = featureConfig.m_159774_();
        blockPos = SulphuricLakeFeature.getPosOnSurfaceWG((WorldGenLevel)world, (BlockPos)blockPos);
        if (blockPos.m_123342_() < 57) {
            return false;
        }
        RandomSource random = featureConfig.m_225041_();
        BlockPos.MutableBlockPos POS = GlobalState.stateForThread().POS;
        double radius = MHelper.randRange((double)10.0, (double)20.0, (RandomSource)random);
        int dist2 = MHelper.floor((double)(radius * 1.5));
        int minX = blockPos.m_123341_() - dist2;
        int maxX = blockPos.m_123341_() + dist2;
        int minZ = blockPos.m_123343_() - dist2;
        int maxZ = blockPos.m_123343_() + dist2;
        HashSet brimstone = Sets.newHashSet();
        for (int x = minX; x <= maxX; ++x) {
            POS.m_142451_(x);
            int x2 = x - blockPos.m_123341_();
            x2 *= x2;
            for (int z = minZ; z <= maxZ; ++z) {
                POS.m_142443_(z);
                int z2 = z - blockPos.m_123343_();
                z2 *= z2;
                double r = radius * (NOISE.eval((double)x * 0.2, (double)z * 0.2) * 0.25 + 0.75);
                double r2 = r * 1.5;
                r *= r;
                r2 *= r2;
                int dist = x2 + z2;
                if ((double)dist <= r) {
                    BlockPos offseted;
                    POS.m_142448_(SulphuricLakeFeature.getYOnSurface((WorldGenLevel)world, (int)x, (int)z) - 1);
                    if (!world.m_8055_((BlockPos)POS).m_204336_(CommonBlockTags.GEN_END_STONES)) continue;
                    if (this.isBorder(world, (BlockPos)POS)) {
                        if (random.m_188503_(8) > 0) {
                            brimstone.add(POS.m_7949_());
                            if (!random.m_188499_()) continue;
                            brimstone.add(POS.m_7495_());
                            if (!random.m_188499_()) continue;
                            brimstone.add(POS.m_6625_(2));
                            continue;
                        }
                        if (!this.isAbsoluteBorder(world, (BlockPos)POS)) {
                            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)POS, (Block)Blocks.f_49990_);
                            world.m_186469_((BlockPos)POS, (Fluid)Fluids.f_76193_, 0);
                            brimstone.add(POS.m_7495_());
                            if (!random.m_188499_()) continue;
                            brimstone.add(POS.m_6625_(2));
                            if (!random.m_188499_()) continue;
                            brimstone.add(POS.m_6625_(3));
                            continue;
                        }
                        brimstone.add(POS.m_7949_());
                        if (!random.m_188499_()) continue;
                        brimstone.add(POS.m_7495_());
                        continue;
                    }
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)POS, (Block)Blocks.f_49990_);
                    brimstone.remove(POS);
                    for (Direction dir : BlocksHelper.HORIZONTAL) {
                        offseted = POS.m_121945_(dir);
                        if (!world.m_8055_(offseted).m_204336_(CommonBlockTags.GEN_END_STONES)) continue;
                        brimstone.add(offseted);
                    }
                    if (this.isDeepWater(world, (BlockPos)POS)) {
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)POS.m_122173_(Direction.DOWN), (Block)Blocks.f_49990_);
                        brimstone.remove(POS);
                        for (Direction dir : BlocksHelper.HORIZONTAL) {
                            offseted = POS.m_121945_(dir);
                            if (!world.m_8055_(offseted).m_204336_(CommonBlockTags.GEN_END_STONES)) continue;
                            brimstone.add(offseted);
                        }
                    }
                    brimstone.add(POS.m_7495_());
                    if (!random.m_188499_()) continue;
                    brimstone.add(POS.m_6625_(2));
                    if (!random.m_188499_()) continue;
                    brimstone.add(POS.m_6625_(3));
                    continue;
                }
                if (!((double)dist < r2)) continue;
                POS.m_142448_(SulphuricLakeFeature.getYOnSurface((WorldGenLevel)world, (int)x, (int)z) - 1);
                if (!world.m_8055_((BlockPos)POS).m_204336_(CommonBlockTags.GEN_END_STONES)) continue;
                brimstone.add(POS.m_7949_());
                if (!random.m_188499_()) continue;
                brimstone.add(POS.m_7495_());
                if (!random.m_188499_()) continue;
                brimstone.add(POS.m_6625_(2));
            }
        }
        brimstone.forEach(bpos -> this.placeBrimstone(world, (BlockPos)bpos, random));
        return true;
    }

    private boolean isBorder(WorldGenLevel world, BlockPos pos) {
        int y = pos.m_123342_() + 1;
        for (Direction dir : BlocksHelper.DIRECTIONS) {
            if (SulphuricLakeFeature.getYOnSurface((WorldGenLevel)world, (int)(pos.m_123341_() + dir.m_122429_()), (int)(pos.m_123343_() + dir.m_122431_())) >= y) continue;
            return true;
        }
        return false;
    }

    private boolean isAbsoluteBorder(WorldGenLevel world, BlockPos pos) {
        int y = pos.m_123342_() - 2;
        for (Direction dir : BlocksHelper.DIRECTIONS) {
            if (SulphuricLakeFeature.getYOnSurface((WorldGenLevel)world, (int)(pos.m_123341_() + dir.m_122429_() * 3), (int)(pos.m_123343_() + dir.m_122431_() * 3)) >= y) continue;
            return true;
        }
        return false;
    }

    private boolean isDeepWater(WorldGenLevel world, BlockPos pos) {
        int y = pos.m_123342_() + 1;
        for (Direction dir : BlocksHelper.DIRECTIONS) {
            if (SulphuricLakeFeature.getYOnSurface((WorldGenLevel)world, (int)(pos.m_123341_() + dir.m_122429_()), (int)(pos.m_123343_() + dir.m_122431_())) >= y && SulphuricLakeFeature.getYOnSurface((WorldGenLevel)world, (int)(pos.m_123341_() + dir.m_122429_() * 2), (int)(pos.m_123343_() + dir.m_122431_() * 2)) >= y && SulphuricLakeFeature.getYOnSurface((WorldGenLevel)world, (int)(pos.m_123341_() + dir.m_122429_() * 3), (int)(pos.m_123343_() + dir.m_122431_() * 3)) >= y) continue;
            return false;
        }
        return true;
    }

    private void placeBrimstone(WorldGenLevel world, BlockPos pos, RandomSource random) {
        BlockState state = this.getBrimstone(world, pos);
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)state);
        if (((Boolean)state.m_61143_((Property)EndBlockProperties.ACTIVE)).booleanValue()) {
            this.makeShards(world, pos, random);
        }
    }

    private BlockState getBrimstone(WorldGenLevel world, BlockPos pos) {
        for (Direction dir : BlocksHelper.DIRECTIONS) {
            if (!world.m_8055_(pos.m_121945_(dir)).m_60713_(Blocks.f_49990_)) continue;
            return (BlockState)EndBlocks.BRIMSTONE.m_49966_().m_61124_((Property)EndBlockProperties.ACTIVE, (Comparable)Boolean.valueOf(true));
        }
        return EndBlocks.BRIMSTONE.m_49966_();
    }

    private void makeShards(WorldGenLevel world, BlockPos pos, RandomSource random) {
        for (Direction dir : BlocksHelper.DIRECTIONS) {
            BlockPos side;
            if (random.m_188503_(16) != 0 || !world.m_8055_(side = pos.m_121945_(dir)).m_60713_(Blocks.f_49990_)) continue;
            BlockState state = (BlockState)((BlockState)((BlockState)EndBlocks.SULPHUR_CRYSTAL.m_49966_().m_61124_((Property)SulphurCrystalBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true))).m_61124_((Property)SulphurCrystalBlock.FACING, (Comparable)dir)).m_61124_((Property)SulphurCrystalBlock.AGE, (Comparable)Integer.valueOf(random.m_188503_(3)));
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)side, (BlockState)state);
        }
    }
}

